<?php
// latest_transactions.php
include('includes/dbconn.php'); // Database connection script

$companyId = $_SESSION['company_id']; // From session

// SQL to fetch the latest transactions for the company
$sql = "SELECT transaction_id, account_id, amount, type, transaction_date, description 
        FROM transactions 
        WHERE company_id = ? 
        ORDER BY transaction_date DESC, transaction_id DESC 
        LIMIT 10"; // Assuming you want the latest 10 transactions
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $companyId);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Latest Transactions</title>
    <!-- jQuery -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <!-- DataTables JS -->
    
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
</head>
<body>

<div class="responsive-table-plugin">
    <div class="table-rep-plugin">
        <div class="table-responsive" data-pattern="priority-columns">
            <table id="latest-transactions" class="table table-striped">
                <thead>
                    <tr>
                        <th>Transaction ID</th>
                        <th>Account ID</th>
                        <th>Amount</th>
                        <th>Type</th>
                        <th>Transaction Date</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['transaction_id']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['account_id']) . "</td>";
                        echo "<td>" . number_format($row['amount'], 2) . "</td>";
                        echo "<td>" . htmlspecialchars($row['type']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['transaction_date']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['description']) . "</td>";
                        echo "</tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div> <!-- end .table-responsive -->
    </div> <!-- end .table-rep-plugin -->
</div> <!-- end .responsive-table-plugin -->
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
$(document).ready( function () {
    $('#latest-transactions').DataTable();
} );
</script>

</body>
</html>

<?php
$stmt->close();
?>
